/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api.message.saaj;

import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.message.Header;
import com.sun.xml.internal.ws.api.message.MessageHeaders;
import com.sun.xml.internal.ws.binding.SOAPBindingImpl;
import com.sun.xml.internal.ws.message.saaj.SAAJHeader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;

public class SAAJMessageHeaders
implements MessageHeaders {
    SOAPMessage sm;
    Map<SOAPHeaderElement, Header> nonSAAJHeaders;
    Map<QName, Integer> notUnderstoodCount;
    SOAPVersion soapVersion;
    private Set<QName> understoodHeaders;

    public SAAJMessageHeaders(SOAPMessage sOAPMessage, SOAPVersion sOAPVersion) {
        this.sm = sOAPMessage;
        this.soapVersion = sOAPVersion;
        this.initHeaderUnderstanding();
    }

    private void initHeaderUnderstanding() {
        SOAPHeader sOAPHeader = this.ensureSOAPHeader();
        if (sOAPHeader == null) {
            return;
        }
        Iterator iterator = sOAPHeader.examineAllHeaderElements();
        while (iterator.hasNext()) {
            SOAPHeaderElement sOAPHeaderElement = (SOAPHeaderElement)iterator.next();
            if (sOAPHeaderElement == null || !sOAPHeaderElement.getMustUnderstand()) continue;
            this.notUnderstood(sOAPHeaderElement.getElementQName());
        }
    }

    @Override
    public void understood(Header header) {
        this.understood(header.getNamespaceURI(), header.getLocalPart());
    }

    @Override
    public void understood(String string, String string2) {
        this.understood(new QName(string, string2));
    }

    @Override
    public void understood(QName qName) {
        Integer n;
        if (this.notUnderstoodCount == null) {
            this.notUnderstoodCount = new HashMap<QName, Integer>();
        }
        if ((n = this.notUnderstoodCount.get(qName)) != null && n > 0) {
            if ((n = Integer.valueOf(n - 1)) <= 0) {
                this.notUnderstoodCount.remove(qName);
            } else {
                this.notUnderstoodCount.put(qName, n);
            }
        }
        if (this.understoodHeaders == null) {
            this.understoodHeaders = new HashSet<QName>();
        }
        this.understoodHeaders.add(qName);
    }

    @Override
    public boolean isUnderstood(Header header) {
        return this.isUnderstood(header.getNamespaceURI(), header.getLocalPart());
    }

    @Override
    public boolean isUnderstood(String string, String string2) {
        return this.isUnderstood(new QName(string, string2));
    }

    @Override
    public boolean isUnderstood(QName qName) {
        if (this.understoodHeaders == null) {
            return false;
        }
        return this.understoodHeaders.contains(qName);
    }

    public boolean isUnderstood(int n) {
        return false;
    }

    @Override
    public Header get(String string, String string2, boolean bl) {
        SOAPHeaderElement sOAPHeaderElement = this.find(string, string2);
        if (sOAPHeaderElement != null) {
            if (bl) {
                this.understood(string, string2);
            }
            return new SAAJHeader(sOAPHeaderElement);
        }
        return null;
    }

    @Override
    public Header get(QName qName, boolean bl) {
        return this.get(qName.getNamespaceURI(), qName.getLocalPart(), bl);
    }

    @Override
    public Iterator<Header> getHeaders(QName qName, boolean bl) {
        return this.getHeaders(qName.getNamespaceURI(), qName.getLocalPart(), bl);
    }

    @Override
    public Iterator<Header> getHeaders(String string, String string2, boolean bl) {
        SOAPHeader sOAPHeader = this.ensureSOAPHeader();
        if (sOAPHeader == null) {
            return null;
        }
        Iterator iterator = sOAPHeader.examineAllHeaderElements();
        if (bl) {
            ArrayList<SAAJHeader> arrayList = new ArrayList<SAAJHeader>();
            while (iterator.hasNext()) {
                SOAPHeaderElement sOAPHeaderElement = (SOAPHeaderElement)iterator.next();
                if (sOAPHeaderElement == null || !sOAPHeaderElement.getNamespaceURI().equals(string) || string2 != null && !sOAPHeaderElement.getLocalName().equals(string2)) continue;
                this.understood(sOAPHeaderElement.getNamespaceURI(), sOAPHeaderElement.getLocalName());
                arrayList.add(new SAAJHeader(sOAPHeaderElement));
            }
            return arrayList.iterator();
        }
        return new HeaderReadIterator(iterator, string, string2);
    }

    @Override
    public Iterator<Header> getHeaders(String string, boolean bl) {
        return this.getHeaders(string, null, bl);
    }

    @Override
    public boolean add(Header header) {
        try {
            header.writeTo(this.sm);
        }
        catch (SOAPException sOAPException) {
            return false;
        }
        this.notUnderstood(new QName(header.getNamespaceURI(), header.getLocalPart()));
        if (this.isNonSAAJHeader(header)) {
            this.addNonSAAJHeader(this.find(header.getNamespaceURI(), header.getLocalPart()), header);
        }
        return true;
    }

    @Override
    public Header remove(QName qName) {
        return this.remove(qName.getNamespaceURI(), qName.getLocalPart());
    }

    @Override
    public Header remove(String string, String string2) {
        QName qName;
        SOAPHeader sOAPHeader = this.ensureSOAPHeader();
        if (sOAPHeader == null) {
            return null;
        }
        SOAPHeaderElement sOAPHeaderElement = this.find(string, string2);
        if (sOAPHeaderElement == null) {
            return null;
        }
        sOAPHeaderElement = (SOAPHeaderElement)sOAPHeader.removeChild(sOAPHeaderElement);
        this.removeNonSAAJHeader(sOAPHeaderElement);
        QName qName2 = qName = string == null ? new QName(string2) : new QName(string, string2);
        if (this.understoodHeaders != null) {
            this.understoodHeaders.remove(qName);
        }
        this.removeNotUnderstood(qName);
        return new SAAJHeader(sOAPHeaderElement);
    }

    private void removeNotUnderstood(QName qName) {
        if (this.notUnderstoodCount == null) {
            return;
        }
        Integer n = this.notUnderstoodCount.get(qName);
        if (n != null) {
            int n2 = n;
            if (--n2 <= 0) {
                this.notUnderstoodCount.remove(qName);
            }
        }
    }

    private SOAPHeaderElement find(QName qName) {
        return this.find(qName.getNamespaceURI(), qName.getLocalPart());
    }

    private SOAPHeaderElement find(String string, String string2) {
        SOAPHeader sOAPHeader = this.ensureSOAPHeader();
        if (sOAPHeader == null) {
            return null;
        }
        Iterator iterator = sOAPHeader.examineAllHeaderElements();
        while (iterator.hasNext()) {
            SOAPHeaderElement sOAPHeaderElement = (SOAPHeaderElement)iterator.next();
            if (!sOAPHeaderElement.getNamespaceURI().equals(string) || !sOAPHeaderElement.getLocalName().equals(string2)) continue;
            return sOAPHeaderElement;
        }
        return null;
    }

    private void notUnderstood(QName qName) {
        Integer n;
        if (this.notUnderstoodCount == null) {
            this.notUnderstoodCount = new HashMap<QName, Integer>();
        }
        if ((n = this.notUnderstoodCount.get(qName)) == null) {
            this.notUnderstoodCount.put(qName, 1);
        } else {
            this.notUnderstoodCount.put(qName, n + 1);
        }
        if (this.understoodHeaders != null) {
            this.understoodHeaders.remove(qName);
        }
    }

    private SOAPHeader ensureSOAPHeader() {
        try {
            SOAPHeader sOAPHeader = this.sm.getSOAPPart().getEnvelope().getHeader();
            if (sOAPHeader != null) {
                return sOAPHeader;
            }
            return this.sm.getSOAPPart().getEnvelope().addHeader();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private boolean isNonSAAJHeader(Header header) {
        return !(header instanceof SAAJHeader);
    }

    private void addNonSAAJHeader(SOAPHeaderElement sOAPHeaderElement, Header header) {
        if (this.nonSAAJHeaders == null) {
            this.nonSAAJHeaders = new HashMap<SOAPHeaderElement, Header>();
        }
        this.nonSAAJHeaders.put(sOAPHeaderElement, header);
    }

    private void removeNonSAAJHeader(SOAPHeaderElement sOAPHeaderElement) {
        if (this.nonSAAJHeaders != null) {
            this.nonSAAJHeaders.remove(sOAPHeaderElement);
        }
    }

    @Override
    public boolean addOrReplace(Header header) {
        this.remove(header.getNamespaceURI(), header.getLocalPart());
        return this.add(header);
    }

    @Override
    public void replace(Header header, Header header2) {
        if (this.remove(header.getNamespaceURI(), header.getLocalPart()) == null) {
            throw new IllegalArgumentException();
        }
        this.add(header2);
    }

    @Override
    public Set<QName> getUnderstoodHeaders() {
        return this.understoodHeaders;
    }

    @Override
    public Set<QName> getNotUnderstoodHeaders(Set<String> set, Set<QName> set2, WSBinding wSBinding) {
        HashSet<QName> hashSet = new HashSet<QName>();
        if (this.notUnderstoodCount == null) {
            return hashSet;
        }
        for (QName qName : this.notUnderstoodCount.keySet()) {
            SOAPHeaderElement sOAPHeaderElement;
            int n = this.notUnderstoodCount.get(qName);
            if (n <= 0 || !(sOAPHeaderElement = this.find(qName)).getMustUnderstand()) continue;
            SAAJHeader sAAJHeader = new SAAJHeader(sOAPHeaderElement);
            boolean bl = false;
            if (set != null) {
                boolean bl2 = bl = !set.contains(sAAJHeader.getRole(this.soapVersion));
            }
            if (bl) continue;
            if (wSBinding != null && wSBinding instanceof SOAPBindingImpl && !(bl = ((SOAPBindingImpl)wSBinding).understandsHeader(qName)) && set2 != null && set2.contains(qName)) {
                bl = true;
            }
            if (bl) continue;
            hashSet.add(qName);
        }
        return hashSet;
    }

    @Override
    public Iterator<Header> getHeaders() {
        SOAPHeader sOAPHeader = this.ensureSOAPHeader();
        if (sOAPHeader == null) {
            return null;
        }
        Iterator iterator = sOAPHeader.examineAllHeaderElements();
        return new HeaderReadIterator(iterator, null, null);
    }

    @Override
    public boolean hasHeaders() {
        SOAPHeader sOAPHeader = this.ensureSOAPHeader();
        if (sOAPHeader == null) {
            return false;
        }
        Iterator iterator = sOAPHeader.examineAllHeaderElements();
        return iterator.hasNext();
    }

    @Override
    public List<Header> asList() {
        SOAPHeader sOAPHeader = this.ensureSOAPHeader();
        if (sOAPHeader == null) {
            return Collections.emptyList();
        }
        Iterator iterator = sOAPHeader.examineAllHeaderElements();
        ArrayList<Header> arrayList = new ArrayList<Header>();
        while (iterator.hasNext()) {
            SOAPHeaderElement sOAPHeaderElement = (SOAPHeaderElement)iterator.next();
            arrayList.add(new SAAJHeader(sOAPHeaderElement));
        }
        return arrayList;
    }

    private static class HeaderReadIterator
    implements Iterator<Header> {
        SOAPHeaderElement current;
        Iterator soapHeaders;
        String myNsUri;
        String myLocalName;

        public HeaderReadIterator(Iterator iterator, String string, String string2) {
            this.soapHeaders = iterator;
            this.myNsUri = string;
            this.myLocalName = string2;
        }

        @Override
        public boolean hasNext() {
            if (this.current == null) {
                this.advance();
            }
            return this.current != null;
        }

        @Override
        public Header next() {
            if (!this.hasNext()) {
                return null;
            }
            if (this.current == null) {
                return null;
            }
            SAAJHeader sAAJHeader = new SAAJHeader(this.current);
            this.current = null;
            return sAAJHeader;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void advance() {
            while (this.soapHeaders.hasNext()) {
                SOAPHeaderElement sOAPHeaderElement = (SOAPHeaderElement)this.soapHeaders.next();
                if (sOAPHeaderElement == null || this.myNsUri != null && !sOAPHeaderElement.getNamespaceURI().equals(this.myNsUri) || this.myLocalName != null && !sOAPHeaderElement.getLocalName().equals(this.myLocalName)) continue;
                this.current = sOAPHeaderElement;
                return;
            }
            this.current = null;
        }
    }
}

